/*
*******************************************************************************
*
* File:         compact.c
* Description:  This file contains the functions for Compact PCI support. 
* Author:       Henrik Liebau, BVS PG
* Created:      Tue Oct 27 11:31:53 1998
* Modified:     Thu Nov  5 16:22:09 1998 (Henrik Liebau) Henrik_Liebau@HP.com
* Language:     C
* Package:      N/A
* Status:       Experimental (Do Not Distribute)
*
* (C) Copyright 1998, Hewlett-Packard GmbH, all rights reserved.
*
*******************************************************************************
*/

#include <typedefs.h>

#include <dynamic.h>
#include <errcapi.h>
#include <iocommon.h>
#include <regconst.h>
#include <session.h>
#include <board.h>
#include <compact.h>

#include <regx24.h>
#include <regx25.h>

/* -----------------------------------------------------------------------
 * Compact PCI Functions
 * -----------------------------------------------------------------------
 */

/*----------------------------------------------------------------------
 * b_errtype EXPORT BestCPCIStatusSet (b_handletype     handle,
 *----------------------------------------------------------------------*/
b_errtype EXPORT BestCPCIStatusSet (b_handletype     handle,
				    b_cpcistatustype status,
				    b_int32 value)
{
  B_DECLARE_FUNCNAME("BestCPCIStatusSet [cpcisset]");
  B_TRY_VARS_NO_PROG;

  B_TRY_BEGIN
  {
    /* are we a compact board? */
    B_TRY_FAIL(BestIsCompact(handle) ? B_E_OK : B_E_ONLY_COMPACT);
    /* license checking */
    B_TRY_LICENSE(B_CAPABILITY_EXERCISER);
    /* dynamic capability checking concerning values of parameters */
    B_TRY(BestParamCheck(handle, B_PARAM_CPCI_STATUS, (b_int32)status, value));

    B_TRY(BestAbstractPropByteSet( handle, CMD_EXE_CPCISTATUS_SET,
				   (b_int8) status, value ));
  }
  
  B_ERRETURN(B_TRY_RET);
}

/*----------------------------------------------------------------------
 * b_errtype EXPORT BestCPCIStatusGet(b_handletype     handle,
 *----------------------------------------------------------------------*/
b_errtype EXPORT BestCPCIStatusGet(b_handletype     handle,
				   b_cpcistatustype status,
				   b_int32 *value)
{
  B_DECLARE_FUNCNAME("BestCPCIStatusGet [cpcisget]");
  B_TRY_VARS_NO_PROG;

  B_TRY_BEGIN
  {
    /* are we a compact board? */
    B_TRY_FAIL(BestIsCompact(handle) ? B_E_OK : B_E_ONLY_COMPACT);
    /* license checking */
    B_TRY_LICENSE(B_CAPABILITY_EXERCISER);
    /* dynamic capability checking concerning values of parameters */
    B_TRY(BestParamProbe(handle, B_PARAM_CPCI_STATUS, (b_int32)status));
    B_TRY_FCT_PARAM_NULL_POINTER(value);

    /* off we go */
    B_TRY(BestAbstractPropByteGet( handle, CMD_EXE_CPCISTATUS_GET,
				   (b_int8) status, value ) );
  }
  
  B_ERRETURN(B_TRY_RET);
}

/*----------------------------------------------------------------------
 * b_errtype EXPORT BestCPCIPinSet(b_handletype         handle,
 *----------------------------------------------------------------------*/
b_errtype EXPORT BestCPCIPinSet(b_handletype         handle,
				b_cpcipintype        pin,
				b_int32               value)
{
  B_DECLARE_FUNCNAME("BestCPCIPinSet [cpcipset]");
  B_TRY_VARS_NO_PROG;

  B_TRY_BEGIN
  {
    /* are we a compact board? */
    B_TRY_FAIL(BestIsCompact(handle) ? B_E_OK : B_E_ONLY_COMPACT);
    /* license checking */
    B_TRY_LICENSE(B_CAPABILITY_EXERCISER);
    /* dynamic capability checking concerning values of parameters */
    B_TRY(BestParamCheck(handle, B_PARAM_CPCI_PIN, (b_int32)pin, value));

    B_TRY(BestAbstractPropByteSet( handle, CMD_EXE_CPCIPIN_SET,
				   (b_int8) pin, value ) );
  }
  
  B_ERRETURN(B_TRY_RET);
}

/*----------------------------------------------------------------------
 * b_errtype EXPORT BestCPCIPinGet(b_handletype         handle,
 *----------------------------------------------------------------------*/
b_errtype EXPORT BestCPCIPinGet(b_handletype         handle,
				b_cpcipintype        pin,
				b_int32              *value )
{
  B_DECLARE_FUNCNAME("BestCPCIPinGet [cpcipget]");
  B_TRY_VARS_NO_PROG;

  B_TRY_BEGIN
  {
    /* are we a compact board? */
    B_TRY_FAIL(BestIsCompact(handle) ? B_E_OK : B_E_ONLY_COMPACT);
    /* license checking */
    B_TRY_LICENSE(B_CAPABILITY_EXERCISER);
    /* dynamic capability checking concerning values of parameters */
    B_TRY(BestParamProbe(handle, B_PARAM_CPCI_PIN, (b_int32)pin));
    B_TRY_FCT_PARAM_NULL_POINTER(value);

    B_TRY(BestAbstractPropByteGet( handle, CMD_EXE_CPCIPIN_GET,
				   (b_int8) pin, value ) );
  }
  
  B_ERRETURN(B_TRY_RET);
}
